<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 19.12.13 10:59
 */

namespace VM\FinancialStatementsBundle\Services\DataStructure;


class FinansowanieProdukcjiDS extends AbstractDataStructure implements InterfaceDataStructure
{
    /**
     * @var float
     */
    public $udzialWRynku = 0.03;

    /**
     * @var int
     */
    public $cenaProduktu = 0;

    /**
     * @var float
     */
    public $nakladyNaPiR = 0;

    /**
     * @var float
     */
    public $nakladyNaInnowacje = 0;

    /**
     * @var float
     */
    public $mozliwosciProdukcyjne = 0;

    /**
     * @var array
     */
    public $kosztyStale = [];

    /**
     * @var array
     */
    public $kosztyZmienne = [];

    /**
     * @var float
     */
    public $wielkoscRynku = 2000000000.00;

    /**
     * @var int
     */
    public $rokPoczatkowy = 1;

    /**
     * @var int
     */
    public $planowanaProdukcja = 0;

    /**
     * @var float
     */
    public $bazowyKosztProdukcji = 2000;

    /**
     * @var float
     */
    public $obnizkaBrakow = 0;

    public function setKosztyStale(array $koszty)
    {
        $this->kosztyStale = $koszty;
    }

    public function setKosztyZmienne(array $koszty)
    {
        $this->kosztyZmienne = $koszty;
    }

    protected function validateUdzialWRynku()
    {
        if(!is_numeric($this->udzialWRynku))
        {
            throw new \Exception('Udział w rynku musi być liczbą rzeczywistą!');
        }

        if(!($this->udzialWRynku > 0))
        {
            throw new \Exception('Udział w rynku musi być większy od 0!');
        }

        if($this->udzialWRynku > 1)
        {
            throw new \Exception('Udział w rynku musi być mniejszy lub równy 1!');
        }
    }

    protected function validateCenaProduktu()
    {
        if(!is_numeric($this->cenaProduktu))
        {
            throw new \Exception('Cena produktu musi być liczbą rzeczywistą!');
        }

        if($this->cenaProduktu < 0)
        {
            throw new \Exception('Cena produktu musi być większa lub równa 0!');
        }
    }

    protected function validateNakladyNaPiR()
    {
        if(!is_numeric($this->nakladyNaPiR))
        {
            throw new \Exception('Nakłady na Promocję i Reklamę muszą być liczbą rzeczywistą!');
        }

        if($this->nakladyNaPiR < 0)
        {
            $this->nakladyNaPiR = 0;
//            throw new \Exception('Nakłady na Promocję i Reklamę muszą być większe lub równe 0!');
        }

        if($this->nakladyNaPiR > 100)
        {
            $this->nakladyNaPiR = 100;
//            throw new \Exception('Nakłady na Promocję i Reklamę muszą być mniejsze lub równe 100!');
        }
    }

    protected function validateNakladyNaInnowacje()
    {
        if(!is_numeric($this->nakladyNaInnowacje))
        {
            throw new \Exception('Nakłady na innowacje muszą być liczbą rzeczywistą!');
        }

        if($this->nakladyNaInnowacje < 0)
        {
            $this->nakladyNaInnowacje = 0;
//            throw new \Exception('Nakłady na innowacje muszą być większe lub równe 0!');
        }

        if($this->nakladyNaInnowacje > 100)
        {
            $this->nakladyNaInnowacje = 100;
//            throw new \Exception('Nakłady na innowacje muszą być mniejsze lub równe 100!');
        }
    }

    protected function validateRokPoczatkowy()
    {
        if(!is_numeric($this->rokPoczatkowy) || !is_int($this->rokPoczatkowy))
        {
            throw new \Exception('Rok początkowy musi być liczbą całkowitą!');
        }

        if($this->rokPoczatkowy < 0)
        {
            throw new \Exception('Rok początkowy musi być większy lub równy 0!');
        }
    }

    protected function validateMozliwosciProdukcyjne()
    {
        try
        {
            $this->mozliwosciProdukcyjne = round($this->mozliwosciProdukcyjne);
        }
        catch(\Exception $e)
        {
            throw new \Exception('Możliwości produkcyjne muszą być liczbą rzeczywistą! Error: '.$e->getMessage());
        }

        if(!is_numeric($this->mozliwosciProdukcyjne))
        {
            throw new \Exception('Możliwości produkcyjne muszą być liczbą całkowitą!');
        }

        if($this->mozliwosciProdukcyjne < 0)
        {
            throw new \Exception('Możliwości produkcyjne muszą być większe lub równe 0!');
        }
    }

    protected function validatePlanowanaProdukcja()
    {
        try
        {
            $this->planowanaProdukcja = floor($this->planowanaProdukcja);
        }
        catch(\Exception $e)
        {
            throw new \Exception('Planowana produkcja musi być liczbą rzeczywistą! Error: '.$e->getMessage());
        }

        if(!is_numeric($this->planowanaProdukcja))
        {
            throw new \Exception('Planowana produkcja musi być liczbą całkowitą!');
        }

        if($this->planowanaProdukcja < 0)
        {
            throw new \Exception('Planowana produkcja musi być większa lub równa 0!');
        }
    }

    protected function validateBazowyKosztProdukcji()
    {
        if(!is_numeric($this->bazowyKosztProdukcji))
        {
            throw new \Exception('Bazowy koszt produkcji musi być liczbą rzeczywistą!');
        }

        if($this->bazowyKosztProdukcji <= 0)
        {
            throw new \Exception('Bazowy koszt produkcji musi być większy od 0!');
        }
    }

    protected function validateObnizkaBrakow()
    {
        if(!is_numeric($this->obnizkaBrakow))
        {
            throw new \Exception('Obniżka braków musi być liczbą rzeczywistą!');
        }

        if($this->obnizkaBrakow < 0)
        {
            throw new \Exception('Obniżka braków musi być większa lub równa 0!');
        }

        if($this->obnizkaBrakow > 100)
        {
            throw new \Exception('Obniżka braków musi być mniejsza lub równa 100!');
        }
    }

    public function validate()
    {
        $this->validateUdzialWRynku();
        $this->validateCenaProduktu();
        $this->validateNakladyNaPiR();
        $this->validateNakladyNaInnowacje();
        $this->validateRokPoczatkowy();
        $this->validateMozliwosciProdukcyjne();
        $this->validatePlanowanaProdukcja();
        $this->validateBazowyKosztProdukcji();
        $this->validateObnizkaBrakow();

        if(!is_array($this->kosztyStale))
        {
            throw new \Exception('Koszty stale powinny być tablicą.');
        }

        foreach($this->kosztyStale as $koszt)
        {
            if($koszt['q'] < 0 || $koszt['kj'] < 0)
            {
                throw new \Exception('Wartości w kosztach stałych powinny być większe lub równe 0.');
            }
        }

        if(!is_array($this->kosztyZmienne))
        {
            throw new \Exception('Koszty zmienne powinny być tablicą.');
        }

        foreach($this->kosztyZmienne as $koszt)
        {
            if($koszt['cenaJednostki'] < 0 || $koszt['kjz'] < 0)
            {
                throw new \Exception('Wartości w kosztach zmiennych powinny być większe lub równe 0.');
            }
        }

        return true;
    }
} 